using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Xml.Schema;

namespace Transform
{
    public partial class frmEDISmapMessageDefinition : Form
    {
        FileStream stream;
        XmlSchema myXmlSchema;
        XmlTextWriter myXmlTextWriter;
        FileStream fs;
        string XSDpath;
        string XMLpath;
        frmEDISmapSegment frmSegment;
        string[] lines;
        clsXMLmessage XMLmessage;
        clsXSDtool XSDtool;
        clsSchemaModel schemaModel;
        string heading = "";

        public frmEDISmapMessageDefinition()
        {
            InitializeComponent();
        }

        // Write out the example of the XSD usage
        public void displayMessageDefinition(OpenFileDialog ofd)
        {
            try
            {
                // create the XML file name
                XSDpath = ofd.FileName;
                int index = ofd.FileName.LastIndexOf(".");
                XMLpath = (ofd.FileName.Substring(0, index) + ".xml");

                // write the XML version and encoding to file
                stream = File.OpenWrite(XMLpath);
                byte[] info = new UTF8Encoding(true).GetBytes("<xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                stream.Write(info, 0, info.Length);

                // write XML message to file
                myXmlTextWriter = new XmlTextWriter(stream, Encoding.UTF8);
                myXmlTextWriter.Formatting = Formatting.Indented;
                myXmlTextWriter.Indentation = 4;

                // read from XMLschema
                fs = new FileStream(ofd.FileName, FileMode.Open);
                myXmlSchema = XmlSchema.Read(fs, new ValidationEventHandler(ShowCompileError));

                XmlSchemaSet schemaSet = new XmlSchemaSet();
                schemaSet.ValidationEventHandler += new ValidationEventHandler(ShowCompileError);
                schemaSet.Add(myXmlSchema);
                schemaSet.Compile();

                XmlSchema compiledSchema = null;
                foreach (XmlSchema schema1 in schemaSet.Schemas())
                {
                    compiledSchema = schema1;
                }
                myXmlSchema = compiledSchema;

                if (myXmlSchema.IsCompiled)
                {
                    // write the XML message to file
                    XMLmessage = new clsXMLmessage(myXmlSchema, myXmlTextWriter); 
                    XMLmessage.buildXMLmessage();
                }
                myXmlTextWriter.Flush();
                stream.Close();
                fs.Close();

                // Open the stream and read it back to the form
                using (FileStream fsTemp = File.OpenRead(XMLpath))
                {
                    byte[] b = new byte[1];
                    UTF8Encoding temp = new UTF8Encoding(true);
                    while (fsTemp.Read(b, 0, b.Length) > 0)
                    {
                        textBox1.AppendText(temp.GetString(b));
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error: Could not read file from disk. Original error: " + ex.Message);
            }
        }

        private static void ShowCompileError(object sender, ValidationEventArgs e)
        {
            MessageBox.Show("Validation Error: " + e.Message);
        }

        private void frmEDISmapMessageDefinition_Resize(object sender, EventArgs e)
        {
            int a = this.Width;
            int b = this.Height;
            textBox1.Size = new Size(a, b);
            this.Validate();
        }

        private void textBox1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            string searchString = "data";
            if (textBox1.SelectedText.Trim().Equals(searchString))
            {
                int[] counts = calculateLineLength();
                for (int i = 0; i < counts.Length; i++)
                {
                    if (textBox1.SelectionStart < counts[i])
                    {
                        findPath(lines[i]);
                        XSDtool = new clsXSDtool(myXmlSchema, heading);
                        XSDtool.accessXSDSchema(); 
                        schemaModel = XSDtool.fillSchemaModel();
                        frmSegment = new frmEDISmapSegment(myXmlSchema, XSDpath, schemaModel);
                        frmSegment.fillForm();
                        frmSegment.Show();
                        break;
                    }
                }
            }
        }

        private int[] calculateLineLength()
        {
            lines = textBox1.Lines;

            int[] counts = new int[lines.Length];
            counts[0] = lines[0].Length;
            for (int i = 1; i < counts.Length; i++)
                counts[i] = lines[i].Length + 2;

            for (int i = 1; i < lines.Length; i++)
                counts[i] = counts[i - 1] + counts[i];
            return counts;
        }

        private void findPath(String line)
        {
            int start = line.LastIndexOf("<");
            int end = line.LastIndexOf(">");
            heading = line.Substring(start + 2, end - start - 2);
        }
    
    }

}